/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.installer;

import dev.vankka.dependencydownload.DependencyManager;
import dev.vankka.dependencydownload.dependency.Dependency;
import dev.vankka.dependencydownload.path.CleanupPathProvider;
import dev.vankka.dependencydownload.path.DependencyPathProvider;
import dev.vankka.dependencydownload.repository.StandardRepository;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;
import org.magmafoundation.magma.MagmaStart;
import org.magmafoundation.magma.common.MagmaConstants;
import org.magmafoundation.magma.common.utils.JarTool;
import org.magmafoundation.magma.common.utils.MD5;
import org.magmafoundation.magma.installer.AbstractMagmaInstaller;
import org.magmafoundation.magma.installer.NetworkUtils;
import org.magmafoundation.magma.utils.LibHelper;
import org.magmafoundation.magma.utils.ServerInitHelper;

public class MagmaInstaller
extends AbstractMagmaInstaller {
    private static final List<String> loadedLibsPaths = new ArrayList<String>();
    private final String magmaVersion = MagmaConstants.VERSION;
    public final File fmlloader = new File(this.libPath + "net/minecraftforge/fmlloader/" + this.mcVer + "-" + this.forgeVer + "/fmlloader-" + this.mcVer + "-" + this.forgeVer + ".jar");
    public final File fmlcore = new File(this.libPath + "net/minecraftforge/fmlcore/" + this.mcVer + "-" + this.forgeVer + "/fmlcore-" + this.mcVer + "-" + this.forgeVer + ".jar");
    public final File javafmllanguage = new File(this.libPath + "net/minecraftforge/javafmllanguage/" + this.mcVer + "-" + this.forgeVer + "/javafmllanguage-" + this.mcVer + "-" + this.forgeVer + ".jar");
    public final File mclanguage = new File(this.libPath + "net/minecraftforge/mclanguage/" + this.mcVer + "-" + this.forgeVer + "/mclanguage-" + this.mcVer + "-" + this.forgeVer + ".jar");
    public final File lowcodelanguage = new File(this.libPath + "net/minecraftforge/lowcodelanguage/" + this.mcVer + "-" + this.forgeVer + "/lowcodelanguage-" + this.mcVer + "-" + this.forgeVer + ".jar");
    public final File mojmap = new File(this.otherStart + "-mappings.txt");
    public final File mc_unpacked = new File(this.otherStart + "-unpacked.jar");
    public final File mergedMapping = new File(this.mcpStart + "-mappings-merged.txt");
    private List<String> arguments;

    public MagmaInstaller(List<String> arguments) {
        this.arguments = Objects.requireNonNullElseGet(arguments, ArrayList::new);
        try {
            this.downloadInternalLibraries();
            new Dependencies(this.mcVer, this.mcpVer, this.minecraft_server);
            this.install();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void install() throws Exception {
        if (this.installInfo.exists()) {
            List<String> lines;
            String storedMagmaMD5;
            String magmaMD5 = MD5.getMd5(JarTool.getFile());
            if (magmaMD5.equals(storedMagmaMD5 = (lines = Files.readAllLines(this.installInfo.toPath())).get(1))) {
                return;
            }
            this.purge();
        }
        ProgressBarBuilder builder = new ProgressBarBuilder().setTaskName("Patching server...").setStyle(ProgressBarStyle.ASCII).setUpdateIntervalMillis(100).setInitialMax(8L);
        try (ProgressBar pb = builder.build();){
            this.copyFileFromJar(this.lzma, "data/server.lzma");
            this.copyFileFromJar(this.universalJar, "data/forge-" + this.mcVer + "-" + this.forgeVer + "-universal.jar");
            this.copyFileFromJar(this.fmlloader, "data/fmlloader-" + this.mcVer + "-" + this.forgeVer + ".jar");
            this.copyFileFromJar(this.fmlcore, "data/fmlcore-" + this.mcVer + "-" + this.forgeVer + ".jar");
            this.copyFileFromJar(this.javafmllanguage, "data/javafmllanguage-" + this.mcVer + "-" + this.forgeVer + ".jar");
            this.copyFileFromJar(this.mclanguage, "data/mclanguage-" + this.mcVer + "-" + this.forgeVer + ".jar");
            this.copyFileFromJar(this.lowcodelanguage, "data/lowcodelanguage-" + this.mcVer + "-" + this.forgeVer + ".jar");
            if (this.magmaVersion == null || this.mcpVer == null) {
                System.out.println("The server has an invalid version and cannot proceed. Please report this to the developer.");
                System.exit(-1);
            }
            if (this.minecraft_server.exists()) {
                this.mute();
                System.out.println("Extracting bundled resources...");
                this.launchService("net.minecraftforge.installertools.ConsoleTool", new ArrayList<String>(Arrays.asList("--task", "BUNDLER_EXTRACT", "--input", this.minecraft_server.getAbsolutePath(), "--output", this.libPath, "--libraries")), this.stringToUrl(loadedLibsPaths));
                File brigadierDir = new File(this.libPath + "com/mojang/brigadier");
                if (brigadierDir.exists()) {
                    Files.walk(brigadierDir.toPath(), new FileVisitOption[0]).map(Path::toFile).forEach(File::delete);
                    brigadierDir.delete();
                }
                this.unmute();
                pb.step();
                if (!this.mc_unpacked.exists()) {
                    this.mute();
                    System.out.println("Extracting jars...");
                    this.launchService("net.minecraftforge.installertools.ConsoleTool", new ArrayList<String>(Arrays.asList("--task", "BUNDLER_EXTRACT", "--input", this.minecraft_server.getAbsolutePath(), "--output", this.mc_unpacked.getAbsolutePath(), "--jar-only")), this.stringToUrl(loadedLibsPaths));
                    this.unmute();
                }
                pb.step();
            } else {
                System.err.println("The server is missing essential files to install properly, delete your libraries folder and try again.");
                System.exit(-1);
            }
            if (this.mcpZip.exists()) {
                if (!this.mcpTxt.exists()) {
                    this.mute();
                    System.out.println("Getting mappings...");
                    this.launchService("net.minecraftforge.installertools.ConsoleTool", new ArrayList<String>(Arrays.asList("--task", "MCP_DATA", "--input", this.mcpZip.getAbsolutePath(), "--output", this.mcpTxt.getAbsolutePath(), "--key", "mappings")), this.stringToUrl(loadedLibsPaths));
                    this.unmute();
                }
            } else {
                System.err.println("The server is missing essential files to install properly, delete your libraries folder and try again.");
                System.exit(-1);
            }
            pb.step();
            if (this.isCorrupted(this.extra)) {
                this.extra.delete();
            }
            if (this.isCorrupted(this.slim)) {
                this.slim.delete();
            }
            if (this.isCorrupted(this.srg)) {
                this.srg.delete();
            }
            if (!this.mojmap.exists()) {
                this.mute();
                System.out.println("Downloading mojang mappings...");
                this.launchService("net.minecraftforge.installertools.ConsoleTool", new ArrayList<String>(Arrays.asList("--task", "DOWNLOAD_MOJMAPS", "--version", this.mcVer, "--side", "server", "--output", this.mojmap.getAbsolutePath())), this.stringToUrl(loadedLibsPaths));
                this.unmute();
            }
            pb.step();
            if (!this.mergedMapping.exists()) {
                this.mute();
                System.out.println("Merging mappings...");
                this.launchService("net.minecraftforge.installertools.ConsoleTool", new ArrayList<String>(Arrays.asList("--task", "MERGE_MAPPING", "--left", this.mcpTxt.getAbsolutePath(), "--right", this.mojmap.getAbsolutePath(), "--output", this.mergedMapping.getAbsolutePath(), "--classes", "--reverse-right")), this.stringToUrl(loadedLibsPaths));
                this.unmute();
            }
            pb.step();
            if (!this.slim.exists() || !this.extra.exists()) {
                this.mute();
                System.out.println("Splitting server jar...");
                this.launchService("net.minecraftforge.jarsplitter.ConsoleTool", new ArrayList<String>(Arrays.asList("--input", this.minecraft_server.getAbsolutePath(), "--slim", this.slim.getAbsolutePath(), "--extra", this.extra.getAbsolutePath(), "--srg", this.mergedMapping.getAbsolutePath())), this.stringToUrl(loadedLibsPaths));
                this.launchService("net.minecraftforge.jarsplitter.ConsoleTool", new ArrayList<String>(Arrays.asList("--input", this.mc_unpacked.getAbsolutePath(), "--slim", this.slim.getAbsolutePath(), "--extra", this.extra.getAbsolutePath(), "--srg", this.mergedMapping.getAbsolutePath())), this.stringToUrl(loadedLibsPaths));
                this.unmute();
            }
            pb.step();
            if (!this.srg.exists()) {
                this.mute();
                System.out.println("Creating srg jar file...");
                this.launchService("net.minecraftforge.fart.Main", new ArrayList<String>(Arrays.asList("--input", this.slim.getAbsolutePath(), "--output", this.srg.getAbsolutePath(), "--names", this.mergedMapping.getAbsolutePath(), "--ann-fix", "--ids-fix", "--src-fix", "--record-fix")), this.stringToUrl(loadedLibsPaths));
                this.unmute();
            }
            pb.step();
            String storedServerMD5 = null;
            String storedMagmaMD5 = null;
            String serverMD5 = MD5.getMd5(this.serverJar);
            String magmaMD5 = MD5.getMd5(JarTool.getFile());
            if (this.installInfo.exists()) {
                List<String> infoLines = Files.readAllLines(this.installInfo.toPath());
                if (infoLines.size() > 0) {
                    storedServerMD5 = infoLines.get(0);
                }
                if (infoLines.size() > 1) {
                    storedMagmaMD5 = infoLines.get(1);
                }
            }
            if (!(this.serverJar.exists() && storedServerMD5 != null && storedMagmaMD5 != null && storedServerMD5.equals(serverMD5) && storedMagmaMD5.equals(magmaMD5))) {
                this.mute();
                System.out.println("Patching forge jar...");
                this.launchService("net.minecraftforge.binarypatcher.ConsoleTool", new ArrayList<String>(Arrays.asList("--clean", this.srg.getAbsolutePath(), "--output", this.serverJar.getAbsolutePath(), "--apply", this.lzma.getAbsolutePath())), this.stringToUrl(new ArrayList<String>(Arrays.asList(this.libPath + "net/minecraftforge/binarypatcher/1.0.12/binarypatcher-1.0.12.jar", this.libPath + "commons-io/commons-io/2.4/commons-io-2.4.jar", this.libPath + "com/google/guava/guava/25.1-jre/guava-25.1-jre.jar", this.libPath + "net/sf/jopt-simple/jopt-simple/5.0.4/jopt-simple-5.0.4.jar", this.libPath + "com/github/jponge/lzma-java/1.3/lzma-java-1.3.jar", this.libPath + "com/nothome/javaxdelta/2.0.1/javaxdelta-2.0.1.jar", this.libPath + "com/google/code/findbugs/jsr305/3.0.2/jsr305-3.0.2.jar", this.libPath + "org/checkerframework/checker-qual/2.0.0/checker-qual-2.0.0.jar", this.libPath + "com/google/errorprone/error_prone_annotations/2.1.3/error_prone_annotations-2.1.3.jar", this.libPath + "com/google/j2objc/j2objc-annotations/1.1/j2objc-annotations-1.1.jar", this.libPath + "org/codehaus/mojo/animal-sniffer-annotations/1.14/animal-sniffer-annotations-1.14.jar", this.libPath + "trove/trove/1.0.2/trove-1.0.2.jar"))));
                this.unmute();
                serverMD5 = MD5.getMd5(this.serverJar);
            }
            pb.step();
            FileWriter fw = new FileWriter(this.installInfo);
            fw.write(serverMD5 + "\n");
            fw.write(magmaMD5);
            fw.close();
        }
        TimeUnit.SECONDS.sleep(1L);
        this.restartServer(this.arguments);
    }

    private void purge() {
        System.out.println("WARNING: It appears you have installed a new version of magma, please remove the libraries folder before continuing. The server will now shut down.");
        System.exit(0);
    }

    private void downloadInternalLibraries() {
        HashMap<File, List<String>> dependencies = new HashMap<File, List<String>>();
        dependencies.put(new File(this.libPath + "dev/vankka/dependencydownload-common/1.2.1/dependencydownload-common-1.2.1.jar"), Arrays.asList("e6b19d4a5e3687432530a0aa9edf6fcc", "https://repo1.maven.org/maven2/dev/vankka/dependencydownload-common/1.2.1/dependencydownload-common-1.2.1.jar"));
        dependencies.put(new File(this.libPath + "dev/vankka/dependencydownload-runtime/1.2.2-SNAPSHOT/dependencydownload-runtime-1.2.2-20220425.122523-9.jar"), Arrays.asList("e8cee80f1719c02ef3076ff42bab0ad9", "https://s01.oss.sonatype.org/content/repositories/snapshots/dev/vankka/dependencydownload-runtime/1.2.2-SNAPSHOT/dependencydownload-runtime-1.2.2-20220425.122523-9.jar"));
        dependencies.put(new File(this.libPath + "org/jline/jline/3.21.0/jline-3.21.0.jar"), Arrays.asList("859778f9cdd3bd42bbaaf0f6f7fe5e6a", "https://repo1.maven.org/maven2/org/jline/jline/3.21.0/jline-3.21.0.jar"));
        dependencies.put(new File(this.libPath + "me/tongfei/progressbar/0.9.3/progressbar-0.9.3.jar"), Arrays.asList("25d3101d2ca7f0847a804208d5411d78", "https://repo1.maven.org/maven2/me/tongfei/progressbar/0.9.3/progressbar-0.9.3.jar"));
        for (File lib : dependencies.keySet()) {
            if (lib.exists() && Objects.equals(MD5.getMd5(lib), ((List)dependencies.get(lib)).get(0))) {
                ServerInitHelper.addToPath(lib.toPath());
                continue;
            }
            lib.getParentFile().mkdirs();
            try {
                NetworkUtils.downloadFile((String)((List)dependencies.get(lib)).get(1), lib, (String)((List)dependencies.get(lib)).get(0));
                ServerInitHelper.addToPath(lib.toPath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class Dependencies {
        private String mcVersion;
        private String mcpVersion;
        private File minecraft_server;

        public Dependencies(String mcVersion, String mcpVersion, File minecraft_server) throws IOException {
            this.mcVersion = mcVersion;
            this.mcpVersion = mcpVersion;
            this.minecraft_server = minecraft_server;
            this.downloadLibraries();
        }

        public void downloadLibraries() throws IOException {
            CleanupPathProvider dependencyPathProvider = new CleanupPathProvider(){
                public final Path baseDirPath = JarTool.getJarDir().toPath();

                public Path getCleanupPath() {
                    return this.baseDirPath;
                }

                public Path getDependencyPath(Dependency dependency, boolean relocated) {
                    return this.baseDirPath.resolve("libraries").resolve(dependency.getGroupId().replace(".", "/")).resolve(dependency.getArtifactId()).resolve(dependency.getVersion()).resolve(dependency.getFileName());
                }
            };
            DependencyManager manager = new DependencyManager((DependencyPathProvider)dependencyPathProvider);
            manager.loadFromResource(new URL("jar:file:" + JarTool.getJarPath() + "!/data/magma_libraries.txt"));
            ExecutorService executor = Executors.newCachedThreadPool();
            ArrayList<StandardRepository> standardRepositories = new ArrayList<StandardRepository>();
            standardRepositories.add(new StandardRepository("https://maven.minecraftforge.net/"));
            standardRepositories.add(new StandardRepository("https://repo1.maven.org/maven2/"));
            standardRepositories.add(new StandardRepository("https://raw.github.com/Hexeption/Magma-Repo/master/"));
            standardRepositories.add(new StandardRepository("https://maven.izzel.io/releases/"));
            List dependencies = manager.getDependencies();
            if (!MagmaStart.postInstall) {
                ProgressBarBuilder builder = new ProgressBarBuilder().setTaskName("Loading libraries...").setStyle(ProgressBarStyle.ASCII).setUpdateIntervalMillis(100).setInitialMax((long)dependencies.size());
                ProgressBar.wrap(dependencies.stream(), (ProgressBarBuilder)builder).forEach(dep -> {
                    try {
                        LibHelper.downloadDependency(manager, dep, standardRepositories);
                        LibHelper.loadDependency(manager, dep, path -> loadedLibsPaths.add(path.toFile().getAbsolutePath()));
                    }
                    catch (IOException | NoSuchAlgorithmException e) {
                        throw new RuntimeException(e);
                    }
                });
            } else {
                manager.downloadAll((Executor)executor, standardRepositories);
                manager.loadAll((Executor)executor, path -> loadedLibsPaths.add(path.toFile().getAbsolutePath()));
            }
            this.downloadMcp(this.mcVersion, this.mcpVersion);
            this.downloadMinecraftServer(this.minecraft_server);
        }

        public void downloadMcp(String mc_version, String mcp_version) {
            File mcp_config = new File(MagmaInstaller.this.libPath + "de/oceanlabs/mcp/mcp_config/" + mc_version + "-" + mcp_version + "/mcp_config-" + mc_version + "-" + mcp_version + ".zip");
            if (Files.exists(mcp_config.toPath(), new LinkOption[0])) {
                return;
            }
            mcp_config.getParentFile().mkdirs();
            try {
                NetworkUtils.downloadFile("https://maven.minecraftforge.net/de/oceanlabs/mcp/mcp_config/" + mc_version + "-" + mcp_version + "/mcp_config-" + mc_version + "-" + mcp_version + ".zip", mcp_config);
            }
            catch (Exception e) {
                System.out.println("Can't find mcp_config");
                e.printStackTrace();
            }
        }

        public void downloadMinecraftServer(File minecraft_server) throws IOException {
            if (Files.exists(minecraft_server.toPath(), new LinkOption[0])) {
                return;
            }
            minecraft_server.getParentFile().mkdirs();
            try {
                NetworkUtils.downloadFile("https://launcher.mojang.com/v1/objects/c8f83c5655308435b3dcf03c06d9fe8740a77469/server.jar", minecraft_server);
            }
            catch (Exception e) {
                System.out.println("Can't download minecraft_server");
                e.printStackTrace();
            }
        }
    }
}

